function [data] = process_T_log_NEW(data_dir)

if data_dir(end)~='\'
    data_dir = [data_dir '\'];
end

cd(data_dir);

f = dir([data_dir '*Temperature_Log.txt']);
g = struct2cell(f);
filelist = g(1,:)';
n = length(filelist);


LV_time = [];
data.Heater     = [];
data.T_optics   = [];
data.T_lab      = [];
data.T_igloo    = [];
data.T_coil     = [];
data.T_plate    = [];
data.T_air      = [];
data.T_plate    = [];
data.T_air      = [];

for i = 1:length(n)
    filename = filelist{i};
    fid = fopen(filename);
    line = fgetl(fid);

    delims = length(regexpi(line,'\t'));
    data_mat = fscanf(fid,'%f',[delims inf]);
    data_mat = data_mat';

    LV_time         =   [LV_time;       data_mat(:,1)];
    data.Heater     =   [data.Heater;   data_mat(:,2)];
    data.T_optics   =   [data.T_optics; data_mat(:,3)];
    data.T_lab      =   [data.T_lab     data_mat(:,4)];
    data.T_igloo    =   [data.T_igloo   data_mat(:,5)];
    data.T_coil     =   [data.T_coil    data_mat(:,6)];
    data.T_plate    =   [data.T_plate   data_mat(:,7)];
    data.T_air      =   [data.T_air     data_mat(:,8)];
    
end

data.time = datetime(LV_time,'ConvertFrom','epochTime','Epoch','1904-01-01','TimeZone','UTC');

end